import random

WIDTH = 39 # Szerokość labiryntu (musi być nieparzysta)
HEIGHT = 19 # Wysokość labiryntu (musi być nieparzysta)
assert WIDTH % 2 == 1 and WIDTH >= 3
assert HEIGHT % 2 == 1 and HEIGHT >= 3
SEED = 1
random.seed(SEED)

# Znaki wykorzystywane do wyświetlania labiryntu:
EMPTY = ' '
MARK = '@'
WALL = chr(9608) # Znak 9608 to '█'.
NORTH, SOUTH, EAST, WEST = 'n', 's', 'e', 'w'

# Na początek tworzymy całkowicie wypełnioną ścianami strukturę danych labiryntu:
maze = {}
for x in range(WIDTH):
    for y in range(HEIGHT):
        maze[(x, y)] = WALL # Na początku każdy element labiryntu to ściana


def printMaze(maze, markX=None, markY=None):
    """Funkcja wyświetla przekazaną jej strukturę danych labiryntu; 
    argumenty markX i markY to współrzędne punktu, w którym 
    aktualnie znajduje się symbol '@' (podczas generowania labiryntu)"""

    for y in range(HEIGHT):
        for x in range(WIDTH):
            if markX == x and markY == y:
                # Wyświetlanie symbolu '@':
                print(MARK, end='')
            else:
                # Wyświetlanie ścian i pustych fragmentów:
                print(maze[(x, y)], end='')
        print() # Przejście do nowej linii po wyświetleniu całego wiersza


def visit(x, y):
    """"Funkcja „wycina” fragment korytarza w punkcie x, y i rekurencyjnie 
    przechodzi do jego nieodwiedzonych jeszcze sąsiadów; funkcja wykonuje nawrót,
    jeżeli znacznik MARK dojdzie do ślepego zaułka"""
    maze[(x, y)] = EMPTY # „Wycinanie” w punkcie x, y.
    printMaze(maze, x, y) # Wyświetlanie stanu labiryntu na poszczególnych etapach jego tworzenia
    print('\n\n')

    while True:
        # Sprawdzenie, który punkt sąsiadujący z punktem, w którym znajduje się znacznik MARK
        # nie został jeszcze odwiedzony:
        unvisitedNeighbors = []
        if y > 1 and (x, y - 2) not in hasVisited:
            unvisitedNeighbors.append(NORTH)

        if y < HEIGHT - 2 and (x, y + 2) not in hasVisited:
            unvisitedNeighbors.append(SOUTH)

        if x > 1 and (x - 2, y) not in hasVisited:
            unvisitedNeighbors.append(WEST)

        if x < WIDTH - 2 and (x + 2, y) not in hasVisited:
            unvisitedNeighbors.append(EAST)

        if len(unvisitedNeighbors) == 0:
            # PRZYPADEK BAZOWY
            # Wszyscy sąsiedzi zostali już odwiedzeni, a więc jesteśmy w 
            # ślepym zaułku. Nawrót do poprzedniego punktu:
            return
        else:
            # PRZYPADEK REKURENCYJNY
            # Losowo wybieramy nieodwiedzonego jeszcze sąsiada:
            nextIntersection = random.choice(unvisitedNeighbors)

            # Przesunięcie znacznika MARK do nieodwiedzonego sąsiada:

            if nextIntersection == NORTH:
                nextX = x
                nextY = y - 2
                maze[(x, y - 1)] = EMPTY # Połączenie dwóch punktów korytarzem
            elif nextIntersection == SOUTH:
                nextX = x
                nextY = y + 2
                maze[(x, y + 1)] = EMPTY # Połączenie dwóch punktów korytarzem
            elif nextIntersection == WEST:
                nextX = x - 2
                nextY = y
                maze[(x - 1, y)] = EMPTY # Połączenie dwóch punktów korytarzem
            elif nextIntersection == EAST:
                nextX = x + 2
                nextY = y
                maze[(x + 1, y)] = EMPTY # Połączenie dwóch punktów korytarzem

            hasVisited.append((nextX, nextY)) # Oznaczenie punktu jako odwiedzonegp
            visit(nextX, nextY)  # Rekurencyjne odwiedzenie tego punktu


# „Wycinanie” ścieżek w strukturze danych labiryntu:
hasVisited = [(1, 1)] # Zaczynamy od odwiedzenia lewego górnego rogu
visit(1, 1)

# Wyświetlenie wynikowej struktury danych:
printMaze(maze)
print(maze)
